<?php
// hotproperty.html.php
/**
* Hot Property's Presentation Code
*
* @package Hot Property 0.9
* @copyright (C) 2004 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <cy@mosets.com>
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class hotproperty_HTML {



	/***
	 * Include CSS file
	 ***/
	function include_CSS() {
		global $hp_css;

	#MOD: magnet0 move the css into template in order to be XHTML Valid
	#   <link rel="stylesheet" href="components/com_hotproperty/css/< ? php echo $hp_css; ? >.css" type="text/css">
	}

	function include_Container_Start() {
#<div id="con_global">
#<div class="componentheading">< ? php #echo _HP_COM_TITLE; ? ></div>
	}
	function include_Container_End() {
#</div>
	}

	/***
	 * Front Page
	 ***/
	function show_Frontpage(&$featured, &$featured_fields_caption, &$featured_total, &$types, &$types_hotproperty, &$types_total) {
		global $hp_fp_show_featured, $hp_fp_show_search, $mainframe;

		$mainframe->setPageTitle( _HP_COM_TITLE );
		if ($hp_fp_show_featured && count($featured) > 0 ){
			hotproperty_HTML::show_fp_Featured($featured, $featured_fields_caption, $featured_total);
			echo '<br class="clearboth" />';
		}

		if ($hp_fp_show_search) {
			hotproperty_HTML::show_Search($types);
			echo '<br class="clearboth" />';
		}

		hotproperty_HTML::show_Types($types, $types_hotproperty, $types_total);
	}

	/***
	 * Featured Listing
	 ***/
	function show_fp_Featured(&$prop, &$caption, $featured_total) {
		global $hp_fp_featured_count, $Itemid;
		
	?>
<div id="con_featured1">
  <div id="heading_Featured"><?php echo _HP_FEATURED_TITLE; ?></div>
  <div id="list_featured">
    <?php 	hotproperty_HTML::list_properties($prop, $caption); ?>
    <br class="clearboth" />
    <?php if ($featured_total > $hp_fp_featured_count) { 
			echo "<a href=\"". sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewfeatured&amp;Itemid=$Itemid") ."\">"._HP_MOREFEATURED."</a>";
		} ?>
  </div>
</div>
<?php
	}

	/***
	 * List Types
	 ***/
	function show_Types(&$types, &$types_hotproperty, $types_total) {
		global $Itemid;
	?>
<div id="con_types1">
  <div id="heading_Types"><?php echo _HP_TYPES_TITLE; ?></div>
  <div id="con_types2">
    <?php
			foreach($types AS $t) { 
				if ($types_total[$t->id]->total > 0) {
				?>
    <div class="con_types3"><a class="types_title" href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewtype&amp;id=$t->id&amp;Itemid=$Itemid");?>"><?php echo $t->name ."</a> [".$types_total[$t->id]->total."]"; ?><br />
      <div class="types_desc"><?php echo $t->desc; 

						if ($types_total[$t->id]->total > 0) { ?><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewtype&amp;id=$t->id&amp;Itemid=$Itemid"); ?>"><?php echo _HP_MORE; ?></a>
        <?php
					}
					?>
      </div>
    </div>
    <?php
				}
			}
		?>
  </div>
</div>
<?php
	}

	/***
	 * Search Facility
	 ***/
	function show_Search(&$types) {
		global $Itemid, $hp_use_advsearch, $mosConfig_live_site;
		/*
		global $custom404, $mosConfig_sef, $sufix;

		# Using Built in SEF feature in Mambo
		if ( !isset($custom404) && $mosConfig_sef ) {
			$onclickCmd = "document.location.href= '$mosConfig_live_site/component/option,com_hotproperty/task,search/Itemid,$Itemid/type,0/search,' + encodeURI(document.searchfrm.hp_search.value) + '/'";
		} elseif ( $mosConfig_sef && isset($custom404) && !empty($sufix) ) {
			
			global $custom_comp, $hp_default_limit_search;
			$hotproperty = "hotproperty";
			if (in_array("hotproperty", $custom_comp)) {
				$hotproperty = array_search($component_name, $custom_comp);
			}

			$onclickCmd = "document.location.href='" . $hotproperty . "/" . _HP_SEF_SEARCH . "/0/".$hp_default_limit_search."/0/" . "' + encodeURI(document.searchfrm.hp_search.value)";

		} else {
			# Using SEF advance or no SEF at all
			$onclickCmd = "document.location.href='" . sefRelToAbs("index.php?option=com_hotproperty&amp;task=search&amp;Itemid=$Itemid&type=0&search=' + encodeURI(document.searchfrm.hp_search.value)");
		}
		*/
	?>
<div id="con_search1">
  <div id="heading_Search"><?php echo _HP_SEARCH_TITLE; ?></div>
  <div id="con_search2">
    <form action="index.php" method="post" name="searchfrm">
      <strong><?php echo _HP_SEARCH_TEXT; ?></strong>
      <input type="text" name="search" class="inputbox" />
      <input type="submit" class="button" value="<?php echo _HP_SEARCH; ?>" />
      <?php
			if ($hp_use_advsearch == '1') {
			?>
      &nbsp;<a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=advsearch&amp;Itemid=$Itemid"); ?>"><?php echo _HP_SEARCH_ADV_TITLE; ?></a>
      <?php
			}
			?>
      <input type="hidden" name="option" value="com_hotproperty" />
      <input type="hidden" name="task" value="search" />
      <input type="hidden" name="Itemid" value="<?php echo $Itemid;?>" />
    </form>
  </div>
</div>
<?php
	}

	/***
	 * Advanced Search Facility
	 ***/
	function show_AdvSearch($fields) {
		global $Itemid, $mainframe;

		$mainframe->setPageTitle( _HP_SEARCH_ADV_TITLE );
	?>
<div id="con_asearch1">
  <div id="heading_AdvSearch"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo  ""._HP_ARROW."" . _HP_SEARCH_ADV_TITLE; ?></div>
  <div id="con_asearch2">
    <form action="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=asearch&amp;Itemid=$Itemid"); ?>" method="post" name="searchfrm">
      <?php
				$i = 1;
				?>
      <div align="right">
        <input type="reset" class="button" value="<?php echo _HP_RESET ?>" />
        &nbsp;
        <input type="submit" value="<?php echo _HP_SEARCH; ?>" class="button" />
        &nbsp;&nbsp;</div>
      <table cellpadding="5" cellspacing="5" border="0" width="100%" id="sptable">
        <?php
				foreach ($fields AS $field) {
					echo "<tr>";
					echo "<td valign=\"top\" class=\"mleft\">".$field->caption."</td><td align=\"left\">".$field->input."</td>";
					echo "</tr>";
			}
			?>
      </table>
      <div align="right">
        <input type="reset" class="button" value="<?php echo _HP_RESET ?>" />
        &nbsp;
        <input type="submit" value="<?php echo _HP_SEARCH; ?>" class="button" />
        &nbsp;&nbsp;</div>
    </form>
    <br />
    <br />
  </div>
</div>
<?php
	}

	/***
	 * Empty Advanced Search Results
	 ***/
	function show_advSearchResults_error($msg) {
		global $Itemid, $mainframe;
		$mainframe->setPageTitle( _HP_SEARCH_ADV_TITLE );
	?>
<div id="con_asearch1">
  <div id="heading_AdvSearch"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo ""._HP_ARROW."" . _HP_SEARCH_ADV_TITLE; ?></div>
  <p />
  <?php echo $msg; ?>
  <p />
  <a href=""><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=advsearch&amp;Itemid=$Itemid"); ?>"><?php echo _HP_SEARCH_TRYAGAIN; ?></a></div>
<?php
	}

	/***
	 * Advanced Search Results
	 ***/
	function show_advSearchResults(&$search_id, &$prop, &$caption, &$pageNav, &$searchString) {
		global $Itemid, $mainframe;
		$mainframe->setPageTitle( _HP_SEARCH_ADV_TITLE );
	?>
<div id="con_asearch1">
  <div id="heading_AdvSearch"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo _HP_ARROW."" . _HP_SEARCH_ADV_TITLE; ?></div>
  <div id="hp_searchresult_con">
    <div id="hp_pagecounter_top"><?php echo $pageNav->writePagesCounter(); ?>&nbsp;&nbsp;<?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=asearch&amp;Itemid='.$Itemid.'&amp;search_id='.$search_id); ?></div>
	<div id="list_searchresults"><?php 	hotproperty_HTML::list_properties($prop, $caption); ?></div>
  </div>  

<br class="clearboth" />
<div id="hp_pagecounter_bottom"><span class="results"><?php echo $pageNav->writePagesCounter(); ?></span> <?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=asearch&amp;Itemid='.$Itemid.'&amp;search_id='.$search_id); ?></div>
</div>
<?php
	}

	/***
	 * Search Results
	 ***/
	function show_SearchResults(&$types, &$prop, &$caption, &$pageNav, &$searchString) {
		global $Itemid, $hp_use_advsearch, $mosConfig_live_site, $mainframe;
		global $custom404, $mosConfig_sef, $sufix;
		$mainframe->setPageTitle( _HP_SEARCH_RESULT_TITLE );

		# Using Built in SEF feature in Mambo
		/*
		if ( !isset($custom404) && $mosConfig_sef ) {

			$onclickCmd = "document.location.href= '$mosConfig_live_site/component/option,com_hotproperty/task,search/Itemid,$Itemid/type,' + document.searchfrm.type.options[document.searchfrm.type.selectedIndex].value + '/search,' + encodeURI(document.searchfrm.hp_search.value) + '/'";

		} elseif ( $mosConfig_sef && isset($custom404) && !empty($sufix) ) {
			
			global $custom_comp, $hp_default_limit_search;
			$hotproperty = "hotproperty";
			if (in_array("hotproperty", $custom_comp)) {
				$hotproperty = array_search($component_name, $custom_comp);
			}

			$onclickCmd = "document.location.href='" . $hotproperty . "/" . _HP_SEF_SEARCH . "/' + document.searchfrm.type.options[document.searchfrm.type.selectedIndex].value + '/".$hp_default_limit_search."/0/" . "' + encodeURI(document.searchfrm.hp_search.value)";

		} else {

		# Using SEF advance or no SEF at all
			$onclickCmd = "document.location.href='" . sefRelToAbs("index.php?option=com_hotproperty&amp;task=search&amp;Itemid=$Itemid&type=' + document.searchfrm.type.options[document.searchfrm.type.selectedIndex].value + '&search=' + encodeURI(document.searchfrm.hp_search.value)");
		}
		*/
	?>
<div id="con_search1">
<div id="heading_Search"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo "" ._HP_ARROW . "" . _HP_SEARCH_RESULT_TITLE; ?></div>
	<div id="con_search2">
<form action="index.php" method="post" name="searchfrm">
  
  <div id="hp_searchresult_con"><strong><?php echo _HP_SEARCH_TEXT; ?></strong>
    <input type="text" name="search" class="inputbox" value="<?php echo $searchString->search; ?>" />
    <?php echo _HP_IN; ?>
    <select name="type" class="inputbox" size="1">
      <option value="0"><?php echo _HP_SEARCH_ALLTYPES; ?></option>
      <?php 
			foreach($types AS $t) { ?>
      <option value="<?php echo $t->id; ?>"<?php echo (($searchString->type==$t->id) ? " selected" : ""); ?>><?php echo $t->name; ?></option>
      <?php	}
		?>
    </select>
    &nbsp;
    <input type="submit" class="button" value="<?php echo _HP_SEARCH; ?>" />
    <?php
			if ($hp_use_advsearch == '1') {
			?>
    <br /><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=advsearch&amp;Itemid=$Itemid"); ?>"><?php echo _HP_SEARCH_ADV_TITLE; ?></a>
    <?php
			}
			?>
    <!--<div id="hp_search_pagecounter_top"><?php echo $pageNav->
    writePagesCounter(); ?>&nbsp;&nbsp;<?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=search&amp;Itemid='.$Itemid.'&amp;type='.$searchString->type.'&search='.$searchString->search); ?></div>
  -->
  </div>
  <input type="hidden" name="option" value="com_hotproperty" />
  <input type="hidden" name="task" value="search" />
</form>
<div id="list_searchresults">
  <?php 	hotproperty_HTML::list_properties($prop, $caption); ?>
</div>
<br class="clearboth" />
<div id="hp_pagecounter_bottom"><span class="results"><?php echo $pageNav->writePagesCounter(); ?></span> <?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=search&amp;Itemid='.$Itemid.'&amp;type='.$searchString->type.'&amp;search='.$searchString->search); ?></div>
</div>
</div>
<?php
	}

	/***
	 * List Properties for a particular Type
	 ***/
	function show_Type($prop, $type, $caption, $pageNav, $sortby_sort, $sortby_order) {
		global $hp_use_diplaynum, $hp_use_sort_name, $hp_use_sort_agent, $hp_use_sort_price, $hp_use_sort_suburb, $hp_use_sort_state, $hp_use_sort_country, $hp_use_sort_type, $hp_use_sort_modified, $hp_use_sort_hits;

		global $Itemid, $database, $mainframe;

		$mainframe->setPageTitle( $type->name );
		?>
<div id="con_type1">
  <div id="heading_Type"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo _HP_ARROW . $type->name; ?></div>
  <?php 
			if ($hp_use_diplaynum == '1' || !empty($hp_use_sort_name) || !empty($hp_use_sort_agent) || !empty($hp_use_sort_price) || !empty($hp_use_sort_suburb) || !empty($hp_use_sort_state) || !empty($hp_use_sort_country) || !empty($hp_use_sort_type) || !empty($hp_use_sort_modified) || !empty($hp_use_sort_hits))	{
		?>
  <div id="con_sort">
    <?php if ($hp_use_diplaynum == '1') { ?>
    <div id="con_sort1"><?php echo _PN_DISPLAY_NR; ?><?php echo $pageNav->writeLimitBox('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort='.$sortby_sort.'&amp;order='.$sortby_order.'&amp;Itemid='.$Itemid); ?></div>
    <?php 
						} 
						if (!empty($hp_use_sort_name) || !empty($hp_use_sort_agent) || !empty($hp_use_sort_price) || !empty($hp_use_sort_suburb) || !empty($hp_use_sort_state) || !empty($hp_use_sort_country) || !empty($hp_use_sort_type) || !empty($hp_use_sort_modified) || !empty($hp_use_sort_hits)) {
			?>
    <div id="con_sort2">&nbsp;<?php echo _HP_SORT_BY; ?>|
      <?php if (!empty($hp_use_sort_name)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=name&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>" title="<?php echo _HP_SORT_A_Z; ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo _HP_SORT_AZ; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=name&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>" title="<?php echo _HP_SORT_Z_A; ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_agent) && !empty($caption['agent']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=agent&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['agent']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=agent&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_price) && !empty($caption['price']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=price&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>" title="<?php echo _HP_SORT_LOWEST_PRICE; ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['price']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=price&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>" title="<?php echo _HP_SORT_HIGHEST_PRICE; ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_suburb) && !empty($caption['suburb']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=suburb&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['suburb']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=suburb&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_state) && !empty($caption['state']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=state&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['state']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=state&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_country) && !empty($caption['country']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=country&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['country']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=country&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_type) && !empty($caption['type']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=type&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['type']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=type&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_modified) && !empty($caption['modified']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=modified&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['modified']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=modified&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
      <?php if (!empty($hp_use_sort_hits) && !empty($caption['hits']->caption)) { ?>
      <a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=hits&amp;order=asc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_ASC; ?></a><?php echo $caption['hits']->caption; ?><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort=hits&amp;order=desc&amp;limit='.$pageNav->limit.'&amp;limitstart='.$pageNav->limitstart.'&amp;Itemid='.$Itemid); ?>"><?php echo _HP_SORT_DESC; ?></a>|
      <?php } ?>
    </div>
    <?php } ?>
  </div>
  <?php } ?>
  <div id="list_properties">
    <?php 	hotproperty_HTML::list_properties($prop, $caption); ?>
  </div>
  <br class="clearboth" />
  <div id="hp_pagecounter_bottom"><span class="results"><?php echo $pageNav->writePagesCounter(); ?></span> <?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=viewtype&amp;id='.$prop[0]->typeid.'&amp;sort='.$sortby_sort.'&amp;order='.$sortby_order.'&amp;Itemid='.$Itemid); 	?></div>
</div>
<?php
	}

	/***
	 * List Featured Properties
	 ***/
	function show_Featured($prop, $caption, $pageNav) {
		global $Itemid, $mainframe;
		$mainframe->setPageTitle( _HP_FEATURED );
		?>
<div id="con_type1">
  <div id="heading_Featured"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo _HP_ARROW . _HP_FEATURED; ?></div>
  <div id="list_properties">
    <?php hotproperty_HTML::list_properties($prop, $caption); ?>
  </div>
  <br class="clearboth" />
  <div id="hp_pagecounter_bottom"><span class="results"><?php echo $pageNav->writePagesCounter(); ?></span> <?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=viewfeatured'); ?></div>
</div>
<?php
	}

	/***
	 * Display Company's contact details and list all agents under it.
	 ***/
	function show_Company($company, $agents, $pageNav) {
		global $mosConfig_live_site, $hp_imgdir_agent, $mainframe, $Itemid;
		$mainframe->setPageTitle( $company[0]->name );
		?>
<div id="heading_Co"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN .""._HP_ARROW.""; ?></a><?php echo _HP_CO_TITLE; ?></div>
<div id="hp_view_co_con">
  <?php hotproperty_HTML::show_CoInfo($company) ?>
</div>
<br class="clearboth" />
<div id="heading_Agent"><?php echo _HP_VIEW_AGENT_TITLE; ?></div>
<div id="list_agents">
  <?php hotproperty_HTML::show_AgentInfo($agents) ?>
</div>
<br class="clearboth" />
<div id="hp_pagecounter_bottom"><span class="results"><?php echo $pageNav->writePagesCounter(); ?></span> <?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=viewco&amp;id='.$company[0]->id); ?></div>
<?php
	}

	/***
	 * Display Agent's information and list all properties under it.
	 ***/
	 function show_Agent($prop, $caption, $agent, $pageNav) {
		 global $mosConfig_live_site, $hp_imgdir_agent, $Itemid, $mainframe;
		$mainframe->setPageTitle( $agent[0]->name );

		?>
<div id="hp_view_agent_title"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN .""._HP_ARROW.""; ?></a><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewco&amp;id=".$agent[0]->companyid."&amp;Itemid=".$Itemid); ?>"><?php echo $agent[0]->company .""._HP_ARROW.""; ?></a><?php echo _HP_VIEW_AGENT_TITLE; ?></div>
<div id="hp_view_agent_con">
  <?php hotproperty_HTML::show_AgentInfo($agent) ?>
</div>
<br class="clearboth" />
<div id="heading_Agent"><?php echo _HP_PROPBYAGENT.$agent[0]->name; ?></div>
<div id="list_properties">
  <?php 	hotproperty_HTML::list_properties($prop, $caption); ?>
</div>
<br class="clearboth" />
<div id="hp_pagecounter_bottom"><span class="results"><?php echo $pageNav->writePagesCounter(); ?></span> <?php echo $pageNav->writePagesLinks('index.php?option=com_hotproperty&amp;task=viewagent&amp;id='.$agent[0]->id); ?></div>
<?php
	}

	/***
	 * Display Company's information and an enquiry form.
	 ***/
	function show_CoEmail($company) {
		global $Itemid, $mainframe;
		$mainframe->setPageTitle( _HP_CO_CONTACT .' - '.$company[0]->name );

		?>
<div id="heading_Co"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN .""._HP_ARROW.""; ?></a><?php echo _HP_CO_TITLE; ?></div>
<div id="hp_view_co_con">
  <?php hotproperty_HTML::show_CoInfo($company) ?>
</div>
<br class="clearboth" />
<div id="heading_Co_Contact"><?php echo _HP_CO_CONTACT; ?></div>
<div id="hp_emailform_con">
  <?php hotproperty_HTML::show_EmailForm('company',$company[0]->id) ?>
</div>
<?php
	}

	/***
	 * Display Agent's information and an enquiry form.
	 ***/
	function show_AgentEmail($agent) {
		global $Itemid, $mainframe;
		$mainframe->setPageTitle( _HP_VIEW_AGENT_CONTACT .' - '.$agent[0]->name );
		?>
<div id="hp_view_agent_title"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN .""._HP_ARROW.""; ?></a><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewco&amp;id=".$agent[0]->companyid."&amp;Itemid=".$Itemid); ?>"><?php echo $agent[0]->company .""._HP_ARROW.""; ?></a><?php echo _HP_VIEW_AGENT_TITLE; ?></div>
<div id="hp_view_agent_con">
  <?php hotproperty_HTML::show_AgentInfo($agent) ?>
</div>
<br class="clearboth" />
<br class="clearboth" />
<div id="hp_view_agent_contact"><?php echo _HP_VIEW_AGENT_CONTACT; ?></div>
<div id="hp_emailform_con">
  <?php hotproperty_HTML::show_EmailForm('agent',$agent[0]->id) ?>
</div>
<?php
	}

	/***
	 * Show Property
	 ***/
	function show_Prop(&$prop, &$caption, &$images, &$agent) {
		global $Itemid, $my, $mosConfig_live_site, $mosConfig_absolute_path, $pop, $mainframe;
		global $hp_imgdir_thumb, $hp_imgdir_standard, $hp_currency, $hp_imgsize_thumb, $hp_img_noimage_thumb, $hp_imgdir_agent, $hp_show_agentdetails, $hp_show_enquiryform, $hp_thousand_sep, $hp_dec_point, $hp_link_open_newwin, $hp_show_moreinfo, $hp_use_companyagent, $hp_dec_string, $hp_thousand_string;
		global $hp_show_pdficon, $hp_show_printicon, $hp_show_emailicon;

		$mainframe->appendMetaTag( 'description', $prop[0]->metadesc );
		$mainframe->appendMetaTag( 'keywords', $prop[0]->metakey );
		$mainframe->setPageTitle( $prop[0]->name );
		?>
<div id="con_hp1">
<div id="heading_Prop"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;Itemid=$Itemid"); ?>"><?php echo _HP_COM_PATHWAY_MAIN; ?></a><?php echo _HP_ARROW; ?><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewtype&amp;id=".$prop[0]->typeid."&amp;Itemid=$Itemid"); ?>"><?php echo $prop[0]->type; ?></a><span><?php echo _HP_ARROW . $prop[0]->name; ?></span>
  <?php
		# Show edit icon for authorized agent
		if ($prop[0]->user == $my->id && $prop[0]->user > 0 && $my->id > 0) { ?>
  &nbsp;<a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=editprop&amp;id=". $prop[0]->id ."&amp;Itemid=$Itemid"); ?>" title="<?php echo _E_EDIT; ?>"><img src="images/M_images/edit.png" width="13" height="14" align="middle" border="0" alt="<?php echo _E_EDIT; ?>" /></a>
  <?php } ?>
</div>
<div id="hp_icons">
  <?php

		if ($hp_show_pdficon && !$pop) {
		?>
  <a href="javascript:void;" onClick="window.open('<?php echo $mosConfig_live_site; ?>/components/com_hotproperty/pdf.php?id=<?php echo $prop[0]->id; ?>', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');" title="<?php echo _CMN_PDF;?>"><img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/pdf_button.png" border="0" alt="<?php echo _CMN_PDF;?>" /></a>&nbsp;
  <?php
		} // End of if $hp_show_pdficon 

		if ($hp_show_printicon) {
			if ($pop) { ?>
  <a href="#" onClick="javascript:window.print(); return false" title="<?php echo _CMN_PRINT;?>">
  <?php
			} else { 
		?>
  <a href="javascript:;" onClick="window.open('<?php echo $mosConfig_live_site; ?>/index2.php?option=com_hotproperty&amp;task=view&amp;id=<?php echo $prop[0]->id; ?>&amp;pop=1', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=740,height=500,directories=no,location=no');" title="<?php echo _CMN_PRINT;?>">
  <?php
			} ?>
  <img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/printButton.png" border="0" alt="<?php echo _CMN_PRINT;?>" /></a>&nbsp;
  <?php } // End of if $hp_show_printicon 

		if ($hp_show_emailicon && !$pop) {
			?>
  <a href="javascript:void"  onClick="window.open('<?php echo $mosConfig_live_site; ?>/index2.php?option=com_hotproperty&amp;task=emailform&amp;id=<?php echo $prop[0]->id; ?>', 'win2', 'status=no,toolbar=no,scrollbars=no,titlebar=no,menubar=no,resizable=yes,width=400,height=235,directories=no,location=no');" title="<?php echo _CMN_EMAIL;?>"><img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/emailButton.png" border='0' alt="<?php echo _CMN_EMAIL; ?>" /></a>&nbsp;
  <?php
		}
		?>
</div>
  <div id="con_hp2">
    <?php if (isset($images[0]->standard) && $images[0]->standard <> '') { 
echo "Start of Images:>>>";
	$standard_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_standard.$images[0]->standard);?>
    <div id="hp_view_standard_photo_con1">
      <div id="hp_view_standard_photo_con2">
        <div id="hp_view_standard_photo_con3">

		  <img name="standard_photo" src="<?php echo $mosConfig_live_site.	$hp_imgdir_standard.$images[0]->standard; ?>" alt="<?php echo $images[0]->title; ?>" />
		</div>
        <!--<div id="hp_view_standard_photo_desc"><?php echo htmlentities($images[0]->desc, ENT_QUOTES); ?>&nbsp;</div>-->
      </div>
    </div>
	<div class="timedSlideshow jdSlideshow" id="mySlideshow"></div>
                        <script type="text/javascript">
                        		countArticle = 0;
								var mySlideData = new Array();
								
							    <?php 
									$tmp_captions = array();
									$tmp_images = array();
									if (count($images) > 1) { ?>
							        <?php 
									$hp_imgdir_thumb2='/components/com_hotproperty/img/thb2/';
										foreach($images AS $image) { 
											if ($image->thumb <> '') {
												$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_thumb2.$image->thumb); 
											}
											array_push($tmp_captions, "'" . htmlentities($image->desc, ENT_QUOTES) ."'");
											array_push($tmp_images, "'" . $image->standard ."'"); ?>
								mySlideData[countArticle++] = new Array(
								'images/test/1.jpg',
								'#',
								'Item 1 Title',
								'Item 1 Description'
								);
											
										 <?php } // End foreach
									 } // End If: count($images) 
								 $tmp_arr = "";
								 $tmp_arr2 = "";	 
								 foreach($tmp_images as $key => $value) {
									$tmp_arr .= $value . ", ";
								}
								foreach($tmp_captions as $key => $value) {
									$tmp_arr2 .= $value . ", ";
								} ?>
@@@@@								
								mySlideData[countArticle++] = new Array(
								'images/test/1.jpg',
								'#',
								'Item 1 Title',
								'Item 1 Description'
								);
								</script>
								<script type="text/javascript">
								function startSlideshow() {
									var slideshow = new showcaseSlideShow($('mySlideshow'), mySlideData);
								}

								addLoadEvent(startSlideshow);
								</script>
<-------------------------------------------------------
<div class="propslideshow" id="propslideshow">
		  <img src="<?php echo $mosConfig_live_site.	$hp_imgdir_standard.$images[0]->standard; ?>" alt="<?php echo $images[0]->title; ?>" width="640" height="225" />
</div>
	
    <?php 
	$tmp_captions = array();
	$tmp_images = array();
	if (count($images) > 1) { ?>
        <?php 
					$hp_imgdir_thumb2='/components/com_hotproperty/img/thb2/';
					foreach($images AS $image) { 
						if ($image->thumb <> '') {
							$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_thumb2.$image->thumb); 
						}
						array_push($tmp_captions, "'" . htmlentities($image->desc, ENT_QUOTES) ."'");
						array_push($tmp_images, "'" . $image->standard ."'");
						
					 } // End foreach
	 } // End If: count($images) 
	 $tmp_arr = "";
	 $tmp_arr2 = "";	 
	 foreach($tmp_images as $key => $value) {
		$tmp_arr .= $value . ", ";
	}
	foreach($tmp_captions as $key => $value) {
		$tmp_arr2 .= $value . ", ";
	}

	 echo "<<< End of Images Script end all";
	 ?>
<script type="text/javascript">
	myShow = new Slideshow('propslideshow', { type: 'push', navigation: 'arrows+', transition: Fx.Transitions.backInOut, duration: [1000, 4000], width: 600, height: 400, captions: ['<?=substr($tmp_arr2, 1, (strlen($tmp_arr2)-3) );?>], images: ['<?=substr($tmp_arr, 1, (strlen($tmp_arr)-3) );?>], hu: '<?=$hp_imgdir_standard; ?>' });
</script>


<-------------------------------------------------------




    <?php } ?>
  </div>
<h6 class="toggler details"><a href="<?php echo $_SERVER['REDIRECT_URL'];?>#details"><?=_HP_DETAIL_DESCRIPTION;?></a></h6>
<div class="accordion">
  <?php foreach($prop AS $p) { ?>
  <div class="hp_view_details">
    <?php 
				foreach($p as $key => $value) {
					if ($key=="name") {
						if (isset($caption['type'])) { 
							if (!$caption['type']->hideCaption) { 
								?><span class="hp_caption"><?php echo $caption[$key]->caption; ?>:</span> <?php 
						}
					    ?><div class="hp_caption_type"><?php echo $p->name; 
						if ($p->prop_status <> "") {
							?><span class="pro_status">[<?php echo $p->prop_status; ?>]</span><?php
						} 
						?></div><?php
					} 
				} // End if (name)

						if ( array_key_exists($key,$caption) && ($key <> 'prop_status' && $key <> 'type' && $key <> 'name' && $key <> 'suburb' && $key <> 'state' && $key <> 'postcode' && $key <> 'country' &&	$caption[$key]->iscore == 1) ){ 
							if ($key=="address") {
								if (!$caption['address']->hideCaption) { ?>
    <span class="hp_caption"><?php echo $caption['address']->caption; ?></span>:<br />
    <?php } ?>
	<br clear="all" />
    <div id="hp_view_addr">
      <?php
										if (trim($p->address)!="") {
											echo "$p->address <br />";
										}
										if ((trim($p->suburb)!="") && (trim($p->state)!="") && (trim($p->postcode)!="")) {
											echo "$p->suburb, $p->state, $p->postcode <br />";
										 } elseif ((trim($p->suburb)!="") && (trim($p->state)!="")) {
											echo "$p->suburb, $p->state <br />";
										} elseif ((trim($p->suburb)!="") && (trim($p->postcode)!="")) {
											echo "$p->suburb, $p->postcode <br />";
										} elseif ((trim($p->state)!="") && (trim($p->postcode)!="")) {
											echo "$p->state, $p->postcode <br />";
										} elseif ((trim($p->state)!="")) {
											echo "$p->state <br />";
										} elseif ((trim($p->suburb)!="")) {
											echo "$p->suburb <br />";
										} elseif ((trim($p->postcode)!="")) {
											echo "$p->postcode <br />";
										}
										if (trim($p->country)!="") {
											echo "$p->country <br />";
										}
									?>
    </div>
    <div id="hp_view_desc">	
    <?php 
							} // End if (address)
							if ($key=="price") {
								if (isset($caption['price'])) { 
									if (!$caption['price']->hideCaption) { ?>
      <span class="hp_caption"><?php echo $caption[$key]->caption; ?></span>
      <?php } 
									echo "<div id=\"hp_price\">".$caption["price"]->prefix_text.$hp_currency."".number_format($p->price, $hp_dec_point, $hp_dec_string, ($hp_thousand_sep) ? $hp_thousand_string:'').$caption["price"]->append_text. "</div><br /> "; 
								} 
							} // End if (price)	
							
							elseif ($key=="type") {
								if (isset($caption['type'])) { 
									if (!$caption['type']->hideCaption) { ?>
        <span class="hp_caption"><?php echo $caption[$key]->caption; ?>:</span>
        <?php } 
									?>
      <span class="hp_caption"><?php echo $p->type; ?></span>
      <?php									
								} 
							} // End if (type)

# MAGNET0 I have disabled the Intro Text inside View
/*							elseif ($key=="intro_text") {
								if ($p->intro_text) { 
									if (!$caption['intro_text']->hideCaption) { ?><span class="hp_caption"><?php echo $caption[$key]->caption; ?>: </span><?php } ?>
									<div class="hp_view_intro_text"><?php echo $p->intro_text; ?></div>
								<?php } 
							} // End if (intro_text)	
*/								
							elseif ($key=="full_text") {
								if ($p->full_text) {
									if (!$caption['full_text']->hideCaption) { ?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?>:</span>
    <?php } ?>
    <div class="hp_view_full_text"><?php echo $p->full_text; ?></div>
    <?php } 
							} // End if (full_text)	

							elseif ($key == "featured") { 
								if (!$caption[$key]->hideCaption) {
									echo '<span class="hp_caption">'.$caption[$key]->caption."</span>: ";
								}
								echo $caption[$key]->prefix_text
									.	( ($value == '1') ? _CMN_YES : _CMN_NO )
									.	$caption[$key]->append_text
									.	"<br />";
							} // End if (featured)

							else {
								if (($key <> "address") && ($key <> "intro_text") && ($key <> "full_text")) {
									if (!$caption[$key]->hideCaption) { ?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?>:</span>
    <?php } 
									echo $value." <br />"; 
								}
							}
						} // End if
					} // End foreach
?>
  </div>
 </div>
</div>

<?php if ($hp_show_moreinfo) { ?>

<h6 class="toggler moreinfo"><a href="<?php echo $_SERVER['REDIRECT_URL'];?>#moreinfo"><?php echo _HP_VIEW_FEATURES_TITLE; ?></a></h6>
<div class="accordion">
<div id="more_details_txt">
<ol>
  <?php	}
			foreach($p as $key => $value) {
				if ( array_key_exists($key,$caption) && ($caption[$key]->name <> 'prop_status' && $caption[$key]->name <> 'name' && $caption[$key]->name <> 'agent' && $caption[$key]->name <> 'address' && $caption[$key]->name <> 'suburb' && $caption[$key]->name <> 'state' && $caption[$key]->name <> 'postcode' && $caption[$key]->name <> 'country' && $caption[$key]->name <> 'price' && $caption[$key]->name <> 'type' && $caption[$key]->name <> 'intro_text' && $caption[$key]->name <> 'full_text' && $caption[$key]->name <> 'thumb' && $caption[$key]->name <> 'thumb_title' && $caption[$key]->name <> '' && $value <> "" && $caption[$key]->iscore == 0) ) { 
				echo "\n\t<li>";
				if (!$caption[$key]->hideCaption) {
###						echo '<span class="hp_caption">'.$caption[$key]->caption.":</span>";
						echo '<span class="hp_caption">'.$caption[$key]->caption.":</span>";						
				}
				if ($caption[$key]->field_type == "checkbox" || $caption[$key]->field_type == "selectmultiple") {
						# Generate list
						$olist = explode("|",$value);
						echo "<ul class=\"olist\">\n";
						foreach ($olist AS $ol) {
							echo "<li>".$ol."</li>\n";
						}
						echo "</ul>\n";
				} elseif($caption[$key]->field_type == "link") {
						// Evaluate mambot style data
						$value = str_replace( '{property_id}', $p->id, $value );
						$value = str_replace( '{type_id}', $p->typeid, $value );
						$value = str_replace( '{agent_id}', $p->agentid, $value );
						$value = str_replace( '{company_id}', $p->companyid, $value );
						$value = str_replace( '{Itemid}', $Itemid, $value );

						echo $caption[$key]->prefix_text;
						$link = explode("|",$value);
						if (count($link) == 1 && ( substr(trim($link[0]),0,4) == "http" || substr(trim($link[0]),0,5) == "index" ) ) {
							?>
  <a <?php echo ($hp_link_open_newwin) ? 'target="_blank" ': ''; ?>href="<?php echo $link[0]; ?>"><?php echo $link[0]; ?></a>
  <?php
						} elseif (count($link) > 1 && ( substr(trim($link[1]),0,4) == "http" || substr(trim($link[1]),0,5) == "index" ) ) {
						?>
  <a <?php echo ($hp_link_open_newwin) ? 'target="_blank" ': ''; ?>href="<?php echo $link[1]; ?>"><?php echo $link[0]; ?></a>
  <?php
						} else {
							echo $value;
						}
						echo $caption[$key]->append_text;
						} else {
							echo "<span class=\"hp_value\">" . $caption[$key]->prefix_text.$value.$caption[$key]->append_text . "</span>";
						}
				echo "</li>";
				} // End if
	} // End foreach
	} ?>
  <?php if ($hp_show_agentdetails && $hp_use_companyagent) { ?>
  <div id="hp_view_agent_title"><?php echo _HP_VIEW_AGENT_TITLE; ?></div>
  <div id="hp_view_agent_con">
    <?php hotproperty_HTML::show_AgentInfo($agent) ?>
  </div>
  <?php } ?>
	</ol>  
  </div>
</div>
<?php if ($hp_show_enquiryform && !$pop) { ?>
<h6 class="toggler contact"><a href="<?php echo $_SERVER['REDIRECT_URL'];?>#contact"><?php echo _HP_VIEW_AGENT_CONTACT; ?></a></h6>
<div class="accordion">
  <div id="hp_emailform_con"><?php hotproperty_HTML::show_EmailForm('property',$prop[0]->id); ?></div>
  <?php } 
		if ($pop) {			
		?>
  <center><a href='javascript:window.close();'><span class="small"><?php echo _PROMPT_CLOSE;?></span></a></center>
  <?php } ?>
</div>
<script type="text/javascript">
	
	var stretchers = $$('div.accordion');
	stretchers.each(function(item){
		item.setStyles({'height': '0', 'overflow': 'hidden'});
	});
	
	window.onload = function(){ //safari cannot get style if window isnt fully loaded
		
		var togglers = $$('h6.toggler');
		
		var bgFx = [];
		
		togglers.each(function(toggler, i){
			toggler.defaultColor = toggler.getStyle('background-color');
		
			//fx creation
			bgFx[i] = new Fx.Color(toggler, 'background-color', {wait: false});
		});
	
		var myAccordion = new Fx.Accordion(togglers, stretchers, { opacity: false, start: false, transition: Fx.Transitions.quadOut,
			
			onActive: function(toggler, i){
				bgFx[i].toColor('#a62300');
				toggler.getFirst().setStyle('color', '#fff');
			},
		
			onBackground: function(toggler, i){
				bgFx[i].clearTimer();
				toggler.setStyle('background-color', toggler.defaultColor);
				toggler.getFirst().setStyle('color', '#222');
			}
		});
		
		//anchors
		function checkHash(){
			var found = false;
			$$('h6.toggler a').each(function(link, i){
				if (window.location.hash.test(link.hash)){
					myAccordion.showThisHideOpen(i);
					found = true;
				}
			});
			return found;
		}

		if (!checkHash()) myAccordion.showThisHideOpen(0);
		
	};
	
	try {
		Window.disableImageCache();
	}catch(e){}
	
</script>
</div>
<?php
	}

	/***
	 * Common Routine to display Agent's Info
	 **/
	function show_AgentInfo($agents) {
		global $mosConfig_live_site, $hp_imgdir_agent, $task, $Itemid, $my;

		if (empty($agents)) {
			echo _HP_AGENT_ERROR_EMPTY;
		} else {
			foreach($agents AS $agent) {
		?>
<div class="hp_view_agent">
  <?php if (!empty($agent->photo)) { ?>
  <div id="hp_view_agent_photo">
    <?php if ($task <> "viewagent") { ?>
    <a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewagent&amp;id=$agent->id&amp;Itemid=$Itemid"); ?>"><img border="0" src="<?php echo $mosConfig_live_site.$hp_imgdir_agent.$agent->photo; ?>" alt="<?php echo $agent->name; ?>" /></a>
    <?php } else { ?>
    <img border="0" src="<?php echo $mosConfig_live_site.$hp_imgdir_agent.$agent->photo; ?>" alt="<?php echo $agent->name; ?>" />
    <?php } ?>
  </div>
  <?php } ?>
  <div id="hp_view_agent_details"><span class="hp_caption_agentname">
    <?php if ($task <> "viewagent") { ?>
    <a id="hp_caption_agentname" href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewagent&amp;id=$agent->id&amp;Itemid=$Itemid"); ?>"><?php echo $agent->name; ?></a>
    <?php } else { ?>
    <?php echo $agent->name; ?>
    <?php } ?>
    </span>
    <?php
				# Show an edit icon to allow user to edit their own profile
				if ($agent->user == $my->id && $agent->user > 0 && $my->id > 0) { ?>
    &nbsp;<a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=editagent&amp;Itemid=$Itemid"); ?>" title="<?php echo _E_EDIT; ?>"><img src="images/M_images/edit.png" width="13" height="14" align="middle" border="0" alt="<?php echo _E_EDIT; ?>" /></a>
    <?php } ?>
    <br />
    <?php 
				# Prevent displaying Company if user is at viewco	
				if ($task<>"viewco") { ?>
    <span class="hp_caption"><?php echo _HP_AGENT_COMPANY; ?>:</span><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewco&amp;id=$agent->companyid&amp;Itemid=$Itemid"); ?>"><?php echo $agent->company; ?></a><br />
    <?php } ?>
    <?php 
				# Display Mobile number if not empty	
				if (!empty($agent->mobile)) { ?>
    <span class="hp_caption"><?php echo _HP_AGENT_MOBILE; ?>:</span><?php echo $agent->mobile; ?><br />
    <?php } ?>
    <?php 
				# Display Number of properties
				?>
    <span class="hp_caption"><?php echo _HP_PROPERTIES; ?>:</span><?php echo $agent->properties; ?><br />
    <?php
				# Display "Send email link" if user at viewagent or viewco	
				if( ($task == "viewagent" || $task == "viewco") && !empty($agent->email) ) { ; ?>
    <a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewagentemail&amp;id=$agent->id&amp;Itemid=$Itemid"); ?>"><?php echo _HP_AGENT_SENDEMAIL; ?></a><br />
    <?php } ?>
    <?php if (!empty($agent->desc)) { ?>
    <div id="hp_view_agent_desc"><?php echo $agent->desc; ?></div>
    <?php } ?>
  </div>
</div>
<br class="clearboth" />
<?php
			} // End Foreach
		} // End If
	}

	/***
	 * Common Routine to display Company's Info
	 **/
	function show_CoInfo($companies) {
		global $mosConfig_live_site, $hp_imgdir_company, $task, $Itemid;

		foreach($companies AS $co) {
	?>
<div class="hp_view_co">
  <?php if (!empty($co->photo)) { ?>
  <div id="hp_view_co_photo"><img src="<?php echo $mosConfig_live_site.$hp_imgdir_company.$co->photo; ?>" alt="<?php echo $co->name; ?>" /></div>
  <?php } ?>
  <div id="hp_view_co_details"><span id="hp_caption_coname">
    <?php if ($task <> "viewco") { ?>
    <a id="hp_caption_coname" href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewco&amp;id=$co->id&amp;Itemid=$Itemid"); ?>"><?php echo $co->name; ?></a>
    <?php } else { 
				echo $co->name;	
			} ?>
    </span><br />
    <div id="hp_co_addr">
      <?php
				if (trim($co->address)!="") {
					echo "$co->address <br />";
				}
				if ((trim($co->suburb)!="") && (trim($co->state)!="") && (trim($co->postcode)!="")) {
					echo "$co->suburb, $co->state, $co->postcode <br />";
				 } elseif ((trim($co->suburb)!="") && (trim($co->state)!="")) {
					echo "$co->suburb, $co->state <br />";
				} elseif ((trim($co->suburb)!="") && (trim($co->postcode)!="")) {
					echo "$co->suburb, $co->postcode <br />";
				} elseif ((trim($co->state)!="") && (trim($co->postcode)!="")) {
					echo "$co->state, $co->postcode <br />";
				} elseif ((trim($co->state)!="")) {
					echo "$co->state <br />";
				} elseif ((trim($co->suburb)!="")) {
					echo "$co->suburb <br />";
				} elseif ((trim($co->postcode)!="")) {
					echo "$co->postcode <br />";
				}
				if (trim($co->country)!="") {
					echo "$co->country <br />";
				}
			?>
    </div>
    <?php if (!empty($co->telephone)) { ?>
    <span class="hp_caption"><?php echo _CONTACT_TELEPHONE; ?></span><?php echo $co->telephone; ?><br />
    <?php }?>
    <?php if (!empty($co->fax)) { ?>
    <span class="hp_caption"><?php echo _CONTACT_FAX; ?></span><?php echo $co->fax; ?><br />
    <?php }?>
    <?php if (!empty($co->website)) { ?>
    <span class="hp_caption"><?php echo _HP_CO_WEBSITE; ?></span><a href="<?php echo $co->website; ?>" target="_blank"><?php echo $co->website; ?></a><br />
    <?php }?>
    <?php if ($task <> "viewcoemail") { ?>
    <a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewcoemail&amp;id=$co->id&amp;Itemid=$Itemid"); ?>"><?php echo _HP_CO_SENDEMAIL; ?></a>
    <?php } ?>
    <?php if (!empty($co->desc)) { 
#MOD:magnet0			<p />
					echo $co->desc; ?>
    <?php } ?>
  </div>
</div>
<br class="clearboth" />
<?php
		}
	}

	/***
	 * Display Email form
	 ***/
	function show_EmailForm($subject, $id) {
		global $Itemid;

		if ($subject <> "agent" && $subject <> "property" && $subject <> "company") return false;
	?>
<form method="post" action="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=sendenquiry&amp;id=".$id."&amp;Itemid=".$Itemid); ?>">
  <span class="hp_caption"><?php echo _CMN_NAME; ?>:</span><br />
  <input type="text" class="inputbox" name="hp_name" size="24" />
  <br />
  <span class="hp_caption"><?php echo _CMN_EMAIL; ?>:</span><br />
  <input type="text" class="inputbox" name="hp_email" size="30" />
  <br />
  <span class="hp_caption"><?php echo _HP_CONTACTNUMBER; ?>:</span><br />
  <input type="text" class="inputbox" name="hp_contactnumber" size="30" />
  <br />
  <span class="hp_caption">Χώρα:</span><br />
  <input type="text" class="inputbox" name="hp_country" size="30" />
  <br />
  <span class="hp_caption"><?php echo _ENQUIRY; ?>:</span><br />
  <textarea rows="4" cols="40" class="inputbox" name="hp_enquiry"></textarea>
  <br />
  <br class="clearboth" />
  <input type="hidden" name="sbj" value="<?php echo $subject; ?>" />
  <input class="button" type="submit" value="<?php echo _HP_SENDENQUIRY; ?>" />
<?php  $validate = josSpoofValue(); ?>
<input type="hidden" name="<?php echo $validate; ?>" value="1" />
  
</form>
<?php
	}

	function sendEmailForm($id, $title) {
		global $mosConfig_sitename;
?>
<script language="javascript" type="text/javascript">
	function submitbutton() {
		var form = document.frontendForm;

		// do field validation
		if (form.email.value == "" || form.youremail.value == "") {
			alert( '<?php echo addslashes( _EMAIL_ERR_NOINFO ); ?>' );
			return false;
		}
		return true;
	}
	</script>
<title><?php echo $mosConfig_sitename; ?>::<?php echo $title; ?></title>
<body class="contentpane">
<form action="index2.php?option=com_hotproperty&task=emailsend" name="frontendForm" method="post" onSubmit="return submitbutton();">
  <table cellspacing="2" cellpadding="2" border="0">
    <tr>
      <td colspan="2"><h3><?php echo _EMAIL_FRIEND; ?></h3></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td width="130" align="right"><?php echo _EMAIL_FRIEND_ADDR; ?></td>
      <td><input type="text" name="email" class="inputbox" size="25" /></td>
    </tr>
    <tr>
      <td height="27" align="right"><?php echo _EMAIL_YOUR_NAME; ?></td>
      <td><input type="text" name="yourname" class="inputbox" size="25" /></td>
    </tr>
    <tr>
      <td align="right"><?php echo _EMAIL_YOUR_MAIL; ?></td>
      <td><input type="text" name="youremail" class="inputbox" size="25" /></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2"><input type="submit" name="submit" class="button" value="<?php echo _BUTTON_SUBMIT_MAIL; ?>" />
        &nbsp;&nbsp;
        <input type="button" name="cancel" value="<?php echo _BUTTON_CANCEL; ?>" class="button" onClick="window.close();" /></td>
    </tr>
  </table>
  <input type="hidden" name="id" value="<?php echo $id; ?>" />
</form>
<?php
	}

	function emailSent( $to ) {
		global $mosConfig_sitename;
?>
<br />
<?php echo _EMAIL_SENT." $to";?> <br />
<br />
<?php if (!$hide_js) { ?>
<a href='javascript:window.close();'> <span class="small"><?php echo _PROMPT_CLOSE;?></span> </a>
<?php
		}
	}
	/***
	 * Common Routine to display properties
	 ***/
	function list_properties(&$prop, &$caption) {
		global $Itemid, $task, $my, $mosConfig_live_site, $mosConfig_absolute_path;
		global $hp_imgdir_thumb, $hp_currency, $hp_imgsize_thumb, $hp_img_noimage_thumb, $hp_thousand_sep, $hp_dec_point, $hp_link_open_newwin, $hp_show_thumb, $hp_dec_string, $hp_thousand_string;

		if(empty($prop)) {
			?>
<div id="hp_error_empty"> <?php echo _HP_PROP_ERROR_EMPTY; ?> </div>
<?php
		} else {
		$alternate_count=2;
			foreach($prop AS $p) {
				if ($p->thumb <> '') {
					$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_thumb.$p->thumb); 
				} else {
					$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_thumb.$hp_img_noimage_thumb); 
				}
			?>
<?php if ($alternate_count == 1 ) {
			 $alternate_count=2; 
			 } else {
			 $alternate_count=1; 			 
			 }?>
<div class="hp_details">
<div class="hp_prop alternate_bgnd<?php echo $alternate_count;?>">
    <?php if ($p->prop_status <> "" ) {
								?>
    <span class="pro_status">*<?php echo $p->prop_status; ?>*&nbsp;&nbsp;</span>
    <?php
							}?>
    <div class="hp_title"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=view&amp;id=$p->id&amp;Itemid=$Itemid"); ?>"><?php echo $p->name; ?></a></div><br clear="all" />


    <?php
							# Show an edit icon to allow user to edit the property
							if ($p->user == $my->id && $p->user > 0 && $my->id > 0) { ?>
    &nbsp; <a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=editprop&amp;id=$p->id&amp;Itemid=$Itemid"); ?>" title="<?php echo _E_EDIT; ?>"><img src="images/M_images/edit.png" width="13" height="14" align="middle" border="0" alt="<?php echo _E_EDIT; ?>" /></a>
    <?php } 
	?><div class="propfloater">
 <?php if ($hp_show_thumb) { ?>
  <div class="img_thumb"><a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=view&amp;id=$p->id&amp;Itemid=$Itemid"); ?>"><img <?php echo $thumb_imgsize[3]; ?> border="0" src="<?php if ($p->thumb <> '') echo $mosConfig_live_site.$hp_imgdir_thumb.$p->thumb;
						else echo $mosConfig_live_site.$hp_imgdir_thumb.$hp_img_noimage_thumb;
					?>" alt="<?php echo $p->thumb_title ?>" /></a></div>
  <?php } 
								foreach($p as $key => $value) {
#								echo $key . "<br />";
									if ( array_key_exists($key,$caption) && ($caption[$key]->name <> 'name' && $caption[$key]->name <> 'thumb' && $caption[$key]->name <> 'thumb_title' && $caption[$key]->name <> '' && $value <> "" ) )
										# Replace '|' with a comma for checkbox and select multiple fields
										if ($caption[$key]->field_type == "checkbox" || $caption[$key]->field_type == "selectmultiple") {
											if (!$caption[$key]->hideCaption) echo '<span class="hp_caption">'.$caption[$key]->caption."</span>: ";
											echo str_replace("|",", ",$value)."<br />";
										# Web Link
										} elseif ($caption[$key]->field_type == "link") {

											// Evaluate mambot style data
											$value = str_replace( '{property_id}', $p->id, $value );
											$value = str_replace( '{type_id}', $p->typeid, $value );
											$value = str_replace( '{agent_id}', $p->agentid, $value );
											$value = str_replace( '{company_id}', $p->companyid, $value );
											$value = str_replace( '{Itemid}', $Itemid, $value );

											if (!$caption[$key]->hideCaption) {
											?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?></span>:
    <?php } 
											echo $caption[$key]->prefix_text;
											$link = explode("|",$value);
											if (count($link) == 1 && ( substr(trim($link[0]),0,4) == "http" || substr(trim($link[0]),0,5) == "index" ) ) {
												?>
    <a <?php echo ($hp_link_open_newwin) ? 'target="_blank" ': ''; ?>href="<?php echo $link[0]; ?>"><?php echo $link[0]; ?></a>
    <?php
											} elseif (count($link) > 1 && ( substr(trim($link[1]),0,4) == "http" || substr(trim($link[1]),0,5) == "index" ) ) {
												?>
    <a <?php echo ($hp_link_open_newwin) ? 'target="_blank" ': ''; ?>href="<?php echo $link[1]; ?>"><?php echo $link[0]; ?></a>
    <?php
											} else {
												echo $value;
											}
											echo $caption[$key]->prefix_text."<br />";

										} elseif ($key <> "prop_status") {
												# Do not display agent field when viewing agent's properties
												# Do not display type field when viewing type's properties
												if ( !($key == "agent" && $task == "viewagent") && !($key =="type" && $task == "viewtype") ) {
																									# Show agent link
													if ($key == "agent") { 
														if (!$caption[$key]->hideCaption) {
														?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?></span>:
    <?php 
														} 
														?>
    <a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewagent&amp;id=$p->agentid&amp;Itemid=$Itemid"); ?>"><?php echo $caption[$key]->prefix_text.$value.$caption[$key]->append_text; ?></a><br />
    <?php
													# Show company link
													} elseif ($key == "company") { 
														if (!$caption[$key]->hideCaption) {
														?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?></span>:
    <?php } 
														?>
    <a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewco&amp;id=".$p->companyid."&amp;Itemid=$Itemid"); ?>"> <?php echo $caption[$key]->prefix_text.$value.$caption[$key]->append_text; ?></a><br />
    <?php
													# Show type link
													} elseif ($key == "type") { 
														if (!$caption[$key]->hideCaption) {
														?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?></span>:
    <?php } 
														?>
	<a href="<?php echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=viewtype&amp;id=".$p->typeid."&amp;Itemid=$Itemid"); ?>"> <?php echo $caption[$key]->prefix_text.$value.$caption[$key]->append_text; ?></a>
    <?php
													# Show Price with proper formating
													} elseif (($key=="price") && $value != "0.00" ) { 
														if (!$caption[$key]->hideCaption) {
														?>
    <span class="hp_caption"><?php echo $caption[$key]->caption; ?></span><div id="hp_price"><?php echo $caption[$key]->prefix_text.$hp_currency."".number_format($value, $hp_dec_point, $hp_dec_string, ($hp_thousand_sep) ? $hp_thousand_string:'').$caption[$key]->append_text; ?></div><br />
    <?php } 													
													# Show Featured as Yes/No instead of 1/0
													} elseif ($key == "featured") { 
														if (!$caption[$key]->hideCaption) {
															echo '<span class="hp_caption">'.$caption[$key]->caption."</span>: ";
														}
														echo $caption[$key]->prefix_text
															.	( ($value == '1') ? _CMN_YES : _CMN_NO )
															.	$caption[$key]->append_text
															.	"<br />";
													# Else, show normal 'caption: value'
													} else {
#														echo "## Lastr Else " . $key . " Value: " . $value;
														if ($key!="price") {
															if (!$caption[$key]->hideCaption) {
																if ( ($key == "address") || ($key == "intro_text") || ($key == "ref") || ($key == "area_desc") ) {															
																	echo '<span class="hp_caption">'.$caption[$key]->caption."</span>: ";
																}
															}
														}
														if ($key=="price") {
#														echo " We have a price:!!!!";
#														echo "Value is : ";
#														var_dump($value);
															if ( $value != "0.00" ) {
															if (!$caption[$key]->hideCaption) {
																echo '<span class="hp_caption">'.$caption[$key]->caption."</span>: ";
															}
																echo $caption[$key]->prefix_text
																	.	$hp_currency." " 
																	.	$value
																	.	$caption[$key]->append_text
																	.	"<br />";
															} 


														} else {
														# viewtype
														if ($task != "viewtype") {
															echo $caption[$key]->prefix_text
																.	$value
																.	$caption[$key]->append_text
																.	"<br />";
															} else {
																if ( ($key == "address") || ($key == "intro_text") || ($key == "ref") || ($key == "area_desc") ) {
																	echo $caption[$key]->prefix_text
																	.	"" . $value
																	.	$caption[$key]->append_text
																	.	"<br />";
																}
														}
														} // End of Check for Price
													}
												}
										}
								}
							?>
							</div>
  </div>
<!--  <br class="clearboth" /> -->
</div>
<br clear="all" />

<?php
			} // End Foreach
		} // End If
	}
}
?>
